class ParseError extends Error{sourceStart;sourceEnd;parserState;constructor(e,n,t,o){super(e),this.name="ParseError",this.sourceStart=n,this.sourceEnd=t,this.parserState=o}}class ParseErrorWithToken extends ParseError{token;constructor(e,n,t,o,r){super(e,n,t,o),this.token=r}}const e={UnexpectedNewLineInString:"Unexpected newline while consuming a string token.",UnexpectedEOFInString:"Unexpected EOF while consuming a string token.",UnexpectedEOFInComment:"Unexpected EOF while consuming a comment.",UnexpectedEOFInURL:"Unexpected EOF while consuming a url token.",UnexpectedEOFInEscapedCodePoint:"Unexpected EOF while consuming an escaped code point.",UnexpectedCharacterInURL:"Unexpected character while consuming a url token.",InvalidEscapeSequenceInURL:"Invalid escape sequence while consuming a url token.",InvalidEscapeSequenceAfterBackslash:'Invalid escape sequence after "\\"'},n="undefined"!=typeof globalThis&&"structuredClone"in globalThis;function cloneTokens(e){return n?structuredClone(e):JSON.parse(JSON.stringify(e))}function stringify(...e){let n="";for(let t=0;t<e.length;t++)n+=e[t][1];return n}const t=45,o=43,r=65533;function checkIfFourCodePointsWouldStartCDO(e){return 60===e.source.codePointAt(e.cursor)&&33===e.source.codePointAt(e.cursor+1)&&e.source.codePointAt(e.cursor+2)===t&&e.source.codePointAt(e.cursor+3)===t}function isDigitCodePoint(e){return void 0!==e&&e>=48&&e<=57}function isUppercaseLetterCodePoint(e){return void 0!==e&&e>=65&&e<=90}function isLowercaseLetterCodePoint(e){return void 0!==e&&e>=97&&e<=122}function isHexDigitCodePoint(e){return void 0!==e&&(e>=48&&e<=57||e>=97&&e<=102||e>=65&&e<=70)}function isLetterCodePoint(e){return isLowercaseLetterCodePoint(e)||isUppercaseLetterCodePoint(e)}function isIdentStartCodePoint(e){return isLetterCodePoint(e)||isNonASCII_IdentCodePoint(e)||95===e}function isIdentCodePoint(e){return isIdentStartCodePoint(e)||isDigitCodePoint(e)||e===t}function isNonASCII_IdentCodePoint(e){return 183===e||8204===e||8205===e||8255===e||8256===e||8204===e||void 0!==e&&(192<=e&&e<=214||216<=e&&e<=246||248<=e&&e<=893||895<=e&&e<=8191||8304<=e&&e<=8591||11264<=e&&e<=12271||12289<=e&&e<=55295||63744<=e&&e<=64975||65008<=e&&e<=65533||e>=65536)}function isNewLine(e){return 10===e||13===e||12===e}function isWhitespace(e){return 32===e||10===e||9===e||13===e||12===e}function checkIfTwoCodePointsAreAValidEscape(e){return 92===e.source.codePointAt(e.cursor)&&!isNewLine(e.source.codePointAt(e.cursor+1))}function checkIfThreeCodePointsWouldStartAnIdentSequence(e,n){return n.source.codePointAt(n.cursor)===t?n.source.codePointAt(n.cursor+1)===t||(!!isIdentStartCodePoint(n.source.codePointAt(n.cursor+1))||92===n.source.codePointAt(n.cursor+1)&&!isNewLine(n.source.codePointAt(n.cursor+2))):!!isIdentStartCodePoint(n.source.codePointAt(n.cursor))||checkIfTwoCodePointsAreAValidEscape(n)}function checkIfThreeCodePointsWouldStartANumber(e){return e.source.codePointAt(e.cursor)===o||e.source.codePointAt(e.cursor)===t?!!isDigitCodePoint(e.source.codePointAt(e.cursor+1))||46===e.source.codePointAt(e.cursor+1)&&isDigitCodePoint(e.source.codePointAt(e.cursor+2)):46===e.source.codePointAt(e.cursor)?isDigitCodePoint(e.source.codePointAt(e.cursor+1)):isDigitCodePoint(e.source.codePointAt(e.cursor))}function checkIfTwoCodePointsStartAComment(e){return 47===e.source.codePointAt(e.cursor)&&42===e.source.codePointAt(e.cursor+1)}function checkIfThreeCodePointsWouldStartCDC(e){return e.source.codePointAt(e.cursor)===t&&e.source.codePointAt(e.cursor+1)===t&&62===e.source.codePointAt(e.cursor+2)}var i,s,c;function mirrorVariantType(e){switch(e){case i.OpenParen:return i.CloseParen;case i.CloseParen:return i.OpenParen;case i.OpenCurly:return i.CloseCurly;case i.CloseCurly:return i.OpenCurly;case i.OpenSquare:return i.CloseSquare;case i.CloseSquare:return i.OpenSquare;default:return null}}function mirrorVariant(e){switch(e[0]){case i.OpenParen:return[i.CloseParen,")",-1,-1,void 0];case i.CloseParen:return[i.OpenParen,"(",-1,-1,void 0];case i.OpenCurly:return[i.CloseCurly,"}",-1,-1,void 0];case i.CloseCurly:return[i.OpenCurly,"{",-1,-1,void 0];case i.OpenSquare:return[i.CloseSquare,"]",-1,-1,void 0];case i.CloseSquare:return[i.OpenSquare,"[",-1,-1,void 0];default:return null}}function consumeComment(n,t){for(t.advanceCodePoint(2);;){const o=t.readCodePoint();if(void 0===o){const o=[i.Comment,t.source.slice(t.representationStart,t.representationEnd+1),t.representationStart,t.representationEnd,void 0];return n.onParseError(new ParseErrorWithToken(e.UnexpectedEOFInComment,t.representationStart,t.representationEnd,["4.3.2. Consume comments","Unexpected EOF"],o)),o}if(42===o&&(void 0!==t.source.codePointAt(t.cursor)&&47===t.source.codePointAt(t.cursor))){t.advanceCodePoint();break}}return[i.Comment,t.source.slice(t.representationStart,t.representationEnd+1),t.representationStart,t.representationEnd,void 0]}function consumeEscapedCodePoint(n,t){const o=t.readCodePoint();if(void 0===o)return n.onParseError(new ParseError(e.UnexpectedEOFInEscapedCodePoint,t.representationStart,t.representationEnd,["4.3.7. Consume an escaped code point","Unexpected EOF"])),r;if(isHexDigitCodePoint(o)){const e=[o];let n;for(;void 0!==(n=t.source.codePointAt(t.cursor))&&isHexDigitCodePoint(n)&&e.length<6;)e.push(n),t.advanceCodePoint();isWhitespace(t.source.codePointAt(t.cursor))&&t.advanceCodePoint();const s=parseInt(String.fromCodePoint(...e),16);return 0===s?r:void 0!==(i=s)&&i>=55296&&i<=57343||s>1114111?r:s}var i;return o}function consumeIdentSequence(e,n){const t=[];for(;;){const o=n.source.codePointAt(n.cursor);if(isIdentCodePoint(o))t.push(o),n.advanceCodePoint(+(o>65535)+1);else{if(!checkIfTwoCodePointsAreAValidEscape(n))return t;n.advanceCodePoint(),t.push(consumeEscapedCodePoint(e,n))}}}function consumeHashToken(e,n){n.advanceCodePoint();const t=n.source.codePointAt(n.cursor);if(void 0!==t&&(isIdentCodePoint(t)||checkIfTwoCodePointsAreAValidEscape(n))){let t=c.Unrestricted;checkIfThreeCodePointsWouldStartAnIdentSequence(0,n)&&(t=c.ID);const o=consumeIdentSequence(e,n);return[i.Hash,n.source.slice(n.representationStart,n.representationEnd+1),n.representationStart,n.representationEnd,{value:String.fromCodePoint(...o),type:t}]}return[i.Delim,"#",n.representationStart,n.representationEnd,{value:"#"}]}function consumeNumber(e,n){let r=s.Integer;for(n.source.codePointAt(n.cursor)!==o&&n.source.codePointAt(n.cursor)!==t||n.advanceCodePoint();isDigitCodePoint(n.source.codePointAt(n.cursor));)n.advanceCodePoint();if(46===n.source.codePointAt(n.cursor)&&isDigitCodePoint(n.source.codePointAt(n.cursor+1)))for(n.advanceCodePoint(2),r=s.Number;isDigitCodePoint(n.source.codePointAt(n.cursor));)n.advanceCodePoint();if(101===n.source.codePointAt(n.cursor)||69===n.source.codePointAt(n.cursor)){if(isDigitCodePoint(n.source.codePointAt(n.cursor+1)))n.advanceCodePoint(2);else{if(n.source.codePointAt(n.cursor+1)!==t&&n.source.codePointAt(n.cursor+1)!==o||!isDigitCodePoint(n.source.codePointAt(n.cursor+2)))return r;n.advanceCodePoint(3)}for(r=s.Number;isDigitCodePoint(n.source.codePointAt(n.cursor));)n.advanceCodePoint()}return r}function consumeNumericToken(e,n){let r;{const e=n.source.codePointAt(n.cursor);e===t?r="-":e===o&&(r="+")}const s=consumeNumber(0,n),c=parseFloat(n.source.slice(n.representationStart,n.representationEnd+1));if(checkIfThreeCodePointsWouldStartAnIdentSequence(0,n)){const t=consumeIdentSequence(e,n);return[i.Dimension,n.source.slice(n.representationStart,n.representationEnd+1),n.representationStart,n.representationEnd,{value:c,signCharacter:r,type:s,unit:String.fromCodePoint(...t)}]}return 37===n.source.codePointAt(n.cursor)?(n.advanceCodePoint(),[i.Percentage,n.source.slice(n.representationStart,n.representationEnd+1),n.representationStart,n.representationEnd,{value:c,signCharacter:r}]):[i.Number,n.source.slice(n.representationStart,n.representationEnd+1),n.representationStart,n.representationEnd,{value:c,signCharacter:r,type:s}]}function consumeWhiteSpace(e){for(;isWhitespace(e.source.codePointAt(e.cursor));)e.advanceCodePoint();return[i.Whitespace,e.source.slice(e.representationStart,e.representationEnd+1),e.representationStart,e.representationEnd,void 0]}!function(e){e.Comment="comment",e.AtKeyword="at-keyword-token",e.BadString="bad-string-token",e.BadURL="bad-url-token",e.CDC="CDC-token",e.CDO="CDO-token",e.Colon="colon-token",e.Comma="comma-token",e.Delim="delim-token",e.Dimension="dimension-token",e.EOF="EOF-token",e.Function="function-token",e.Hash="hash-token",e.Ident="ident-token",e.Number="number-token",e.Percentage="percentage-token",e.Semicolon="semicolon-token",e.String="string-token",e.URL="url-token",e.Whitespace="whitespace-token",e.OpenParen="(-token",e.CloseParen=")-token",e.OpenSquare="[-token",e.CloseSquare="]-token",e.OpenCurly="{-token",e.CloseCurly="}-token",e.UnicodeRange="unicode-range-token"}(i||(i={})),function(e){e.Integer="integer",e.Number="number"}(s||(s={})),function(e){e.Unrestricted="unrestricted",e.ID="id"}(c||(c={}));class Reader{cursor=0;source="";representationStart=0;representationEnd=-1;constructor(e){this.source=e}advanceCodePoint(e=1){this.cursor=this.cursor+e,this.representationEnd=this.cursor-1}readCodePoint(){const e=this.source.codePointAt(this.cursor);if(void 0!==e)return this.cursor=this.cursor+1,this.representationEnd=this.cursor-1,e}unreadCodePoint(e=1){this.cursor=this.cursor-e,this.representationEnd=this.cursor-1}resetRepresentation(){this.representationStart=this.cursor,this.representationEnd=-1}}function consumeStringToken(n,t){let o="";const r=t.readCodePoint();for(;;){const s=t.readCodePoint();if(void 0===s){const r=[i.String,t.source.slice(t.representationStart,t.representationEnd+1),t.representationStart,t.representationEnd,{value:o}];return n.onParseError(new ParseErrorWithToken(e.UnexpectedEOFInString,t.representationStart,t.representationEnd,["4.3.5. Consume a string token","Unexpected EOF"],r)),r}if(isNewLine(s)){t.unreadCodePoint();const o=[i.BadString,t.source.slice(t.representationStart,t.representationEnd+1),t.representationStart,t.representationEnd,void 0];return n.onParseError(new ParseErrorWithToken(e.UnexpectedNewLineInString,t.representationStart,13===t.source.codePointAt(t.cursor)&&10===t.source.codePointAt(t.cursor+1)?t.representationEnd+2:t.representationEnd+1,["4.3.5. Consume a string token","Unexpected newline"],o)),o}if(s===r)return[i.String,t.source.slice(t.representationStart,t.representationEnd+1),t.representationStart,t.representationEnd,{value:o}];if(92!==s)o+=String.fromCodePoint(s);else{if(void 0===t.source.codePointAt(t.cursor))continue;if(isNewLine(t.source.codePointAt(t.cursor))){13===t.source.codePointAt(t.cursor)&&10===t.source.codePointAt(t.cursor+1)&&t.advanceCodePoint(),t.advanceCodePoint();continue}o+=String.fromCodePoint(consumeEscapedCodePoint(n,t))}}}function checkIfCodePointsMatchURLIdent(e){return!(3!==e.length||117!==e[0]&&85!==e[0]||114!==e[1]&&82!==e[1]||108!==e[2]&&76!==e[2])}function consumeBadURL(e,n){for(;;){const t=n.source.codePointAt(n.cursor);if(void 0===t)return;if(41===t)return void n.advanceCodePoint();checkIfTwoCodePointsAreAValidEscape(n)?(n.advanceCodePoint(),consumeEscapedCodePoint(e,n)):n.advanceCodePoint()}}function consumeUrlToken(n,t){for(;isWhitespace(t.source.codePointAt(t.cursor));)t.advanceCodePoint();let o="";for(;;){if(void 0===t.source.codePointAt(t.cursor)){const r=[i.URL,t.source.slice(t.representationStart,t.representationEnd+1),t.representationStart,t.representationEnd,{value:o}];return n.onParseError(new ParseErrorWithToken(e.UnexpectedEOFInURL,t.representationStart,t.representationEnd,["4.3.6. Consume a url token","Unexpected EOF"],r)),r}if(41===t.source.codePointAt(t.cursor))return t.advanceCodePoint(),[i.URL,t.source.slice(t.representationStart,t.representationEnd+1),t.representationStart,t.representationEnd,{value:o}];if(isWhitespace(t.source.codePointAt(t.cursor))){for(t.advanceCodePoint();isWhitespace(t.source.codePointAt(t.cursor));)t.advanceCodePoint();if(void 0===t.source.codePointAt(t.cursor)){const r=[i.URL,t.source.slice(t.representationStart,t.representationEnd+1),t.representationStart,t.representationEnd,{value:o}];return n.onParseError(new ParseErrorWithToken(e.UnexpectedEOFInURL,t.representationStart,t.representationEnd,["4.3.6. Consume a url token","Consume as much whitespace as possible","Unexpected EOF"],r)),r}return 41===t.source.codePointAt(t.cursor)?(t.advanceCodePoint(),[i.URL,t.source.slice(t.representationStart,t.representationEnd+1),t.representationStart,t.representationEnd,{value:o}]):(consumeBadURL(n,t),[i.BadURL,t.source.slice(t.representationStart,t.representationEnd+1),t.representationStart,t.representationEnd,void 0])}const s=t.source.codePointAt(t.cursor);if(34===s||39===s||40===s||void 0!==(r=s)&&(11===r||127===r||0<=r&&r<=8||14<=r&&r<=31)){consumeBadURL(n,t);const o=[i.BadURL,t.source.slice(t.representationStart,t.representationEnd+1),t.representationStart,t.representationEnd,void 0];return n.onParseError(new ParseErrorWithToken(e.UnexpectedCharacterInURL,t.representationStart,t.representationEnd,["4.3.6. Consume a url token","Unexpected U+0022 QUOTATION MARK (\"), U+0027 APOSTROPHE ('), U+0028 LEFT PARENTHESIS (() or non-printable code point"],o)),o}if(92===s){if(checkIfTwoCodePointsAreAValidEscape(t)){t.advanceCodePoint(),o+=String.fromCodePoint(consumeEscapedCodePoint(n,t));continue}consumeBadURL(n,t);const r=[i.BadURL,t.source.slice(t.representationStart,t.representationEnd+1),t.representationStart,t.representationEnd,void 0];return n.onParseError(new ParseErrorWithToken(e.InvalidEscapeSequenceInURL,t.representationStart,t.representationEnd,["4.3.6. Consume a url token","U+005C REVERSE SOLIDUS (\\)","The input stream does not start with a valid escape sequence"],r)),r}o+=t.source[t.cursor],t.advanceCodePoint()}var r}function consumeIdentLikeToken(e,n){const t=consumeIdentSequence(e,n);if(40!==n.source.codePointAt(n.cursor))return[i.Ident,n.source.slice(n.representationStart,n.representationEnd+1),n.representationStart,n.representationEnd,{value:String.fromCodePoint(...t)}];if(checkIfCodePointsMatchURLIdent(t)){n.advanceCodePoint();let o=0;for(;;){const e=isWhitespace(n.source.codePointAt(n.cursor)),r=isWhitespace(n.source.codePointAt(n.cursor+1));if(e&&r){o+=1,n.advanceCodePoint(1);continue}const s=e?n.source.codePointAt(n.cursor+1):n.source.codePointAt(n.cursor);if(34===s||39===s)return o>0&&n.unreadCodePoint(o),[i.Function,n.source.slice(n.representationStart,n.representationEnd+1),n.representationStart,n.representationEnd,{value:String.fromCodePoint(...t)}];break}return consumeUrlToken(e,n)}return n.advanceCodePoint(),[i.Function,n.source.slice(n.representationStart,n.representationEnd+1),n.representationStart,n.representationEnd,{value:String.fromCodePoint(...t)}]}function checkIfThreeCodePointsWouldStartAUnicodeRange(e){return!(117!==e.source.codePointAt(e.cursor)&&85!==e.source.codePointAt(e.cursor)||e.source.codePointAt(e.cursor+1)!==o||63!==e.source.codePointAt(e.cursor+2)&&!isHexDigitCodePoint(e.source.codePointAt(e.cursor+2)))}function consumeUnicodeRangeToken(e,n){n.advanceCodePoint(2);const o=[],r=[];let s;for(;void 0!==(s=n.source.codePointAt(n.cursor))&&o.length<6&&isHexDigitCodePoint(s);)o.push(s),n.advanceCodePoint();for(;void 0!==(s=n.source.codePointAt(n.cursor))&&o.length<6&&63===s;)0===r.length&&r.push(...o),o.push(48),r.push(70),n.advanceCodePoint();if(!r.length&&n.source.codePointAt(n.cursor)===t&&isHexDigitCodePoint(n.source.codePointAt(n.cursor+1)))for(n.advanceCodePoint();void 0!==(s=n.source.codePointAt(n.cursor))&&r.length<6&&isHexDigitCodePoint(s);)r.push(s),n.advanceCodePoint();if(!r.length){const e=parseInt(String.fromCodePoint(...o),16);return[i.UnicodeRange,n.source.slice(n.representationStart,n.representationEnd+1),n.representationStart,n.representationEnd,{startOfRange:e,endOfRange:e}]}const c=parseInt(String.fromCodePoint(...o),16),a=parseInt(String.fromCodePoint(...r),16);return[i.UnicodeRange,n.source.slice(n.representationStart,n.representationEnd+1),n.representationStart,n.representationEnd,{startOfRange:c,endOfRange:a}]}function tokenize(e,n){const t=tokenizer(e,n),o=[];for(;!t.endOfFile();)o.push(t.nextToken());return o.push(t.nextToken()),o}function tokenizer(n,r){const s=n.css.valueOf(),c=n.unicodeRangesAllowed??!1,a=new Reader(s),u={onParseError:r?.onParseError??noop};return{nextToken:function nextToken(){a.resetRepresentation();const n=a.source.codePointAt(a.cursor);if(void 0===n)return[i.EOF,"",-1,-1,void 0];if(47===n&&checkIfTwoCodePointsStartAComment(a))return consumeComment(u,a);if(c&&(117===n||85===n)&&checkIfThreeCodePointsWouldStartAUnicodeRange(a))return consumeUnicodeRangeToken(0,a);if(isIdentStartCodePoint(n))return consumeIdentLikeToken(u,a);if(isDigitCodePoint(n))return consumeNumericToken(u,a);switch(n){case 44:return a.advanceCodePoint(),[i.Comma,",",a.representationStart,a.representationEnd,void 0];case 58:return a.advanceCodePoint(),[i.Colon,":",a.representationStart,a.representationEnd,void 0];case 59:return a.advanceCodePoint(),[i.Semicolon,";",a.representationStart,a.representationEnd,void 0];case 40:return a.advanceCodePoint(),[i.OpenParen,"(",a.representationStart,a.representationEnd,void 0];case 41:return a.advanceCodePoint(),[i.CloseParen,")",a.representationStart,a.representationEnd,void 0];case 91:return a.advanceCodePoint(),[i.OpenSquare,"[",a.representationStart,a.representationEnd,void 0];case 93:return a.advanceCodePoint(),[i.CloseSquare,"]",a.representationStart,a.representationEnd,void 0];case 123:return a.advanceCodePoint(),[i.OpenCurly,"{",a.representationStart,a.representationEnd,void 0];case 125:return a.advanceCodePoint(),[i.CloseCurly,"}",a.representationStart,a.representationEnd,void 0];case 39:case 34:return consumeStringToken(u,a);case 35:return consumeHashToken(u,a);case o:case 46:return checkIfThreeCodePointsWouldStartANumber(a)?consumeNumericToken(u,a):(a.advanceCodePoint(),[i.Delim,a.source[a.representationStart],a.representationStart,a.representationEnd,{value:a.source[a.representationStart]}]);case 10:case 13:case 12:case 9:case 32:return consumeWhiteSpace(a);case t:return checkIfThreeCodePointsWouldStartANumber(a)?consumeNumericToken(u,a):checkIfThreeCodePointsWouldStartCDC(a)?(a.advanceCodePoint(3),[i.CDC,"--\x3e",a.representationStart,a.representationEnd,void 0]):checkIfThreeCodePointsWouldStartAnIdentSequence(0,a)?consumeIdentLikeToken(u,a):(a.advanceCodePoint(),[i.Delim,"-",a.representationStart,a.representationEnd,{value:"-"}]);case 60:return checkIfFourCodePointsWouldStartCDO(a)?(a.advanceCodePoint(4),[i.CDO,"\x3c!--",a.representationStart,a.representationEnd,void 0]):(a.advanceCodePoint(),[i.Delim,"<",a.representationStart,a.representationEnd,{value:"<"}]);case 64:if(a.advanceCodePoint(),checkIfThreeCodePointsWouldStartAnIdentSequence(0,a)){const e=consumeIdentSequence(u,a);return[i.AtKeyword,a.source.slice(a.representationStart,a.representationEnd+1),a.representationStart,a.representationEnd,{value:String.fromCodePoint(...e)}]}return[i.Delim,"@",a.representationStart,a.representationEnd,{value:"@"}];case 92:{if(checkIfTwoCodePointsAreAValidEscape(a))return consumeIdentLikeToken(u,a);a.advanceCodePoint();const n=[i.Delim,"\\",a.representationStart,a.representationEnd,{value:"\\"}];return u.onParseError(new ParseErrorWithToken(e.InvalidEscapeSequenceAfterBackslash,a.representationStart,a.representationEnd,["4.3.1. Consume a token","U+005C REVERSE SOLIDUS (\\)","The input stream does not start with a valid escape sequence"],n)),n}}return a.advanceCodePoint(),[i.Delim,a.source[a.representationStart],a.representationStart,a.representationEnd,{value:a.source[a.representationStart]}]},endOfFile:function endOfFile(){return void 0===a.source.codePointAt(a.cursor)}}}function noop(){}function mutateIdent(e,n){const t=[];for(const e of n)t.push(e.codePointAt(0));const o=String.fromCodePoint(...ensureThatValueRoundTripsAsIdent(t));e[1]=o,e[4].value=n}function mutateUnit(e,n){const t=[];for(const e of n)t.push(e.codePointAt(0));const o=ensureThatValueRoundTripsAsIdent(t);101===o[0]&&insertEscapedCodePoint(o,0,o[0]);const r=String.fromCodePoint(...o),i="+"===e[4].signCharacter?e[4].signCharacter:"",s=e[4].value.toString();e[1]=`${i}${s}${r}`,e[4].unit=n}function ensureThatValueRoundTripsAsIdent(e){let n=0;e[0]===t&&e[1]===t?n=2:e[0]===t&&e[1]?(n=2,isIdentStartCodePoint(e[1])||(n+=insertEscapedCodePoint(e,1,e[1]))):isIdentStartCodePoint(e[0])?n=1:(n=1,n+=insertEscapedCodePoint(e,0,e[0]));for(let t=n;t<e.length;t++)isIdentCodePoint(e[t])||(t+=insertEscapedCodePoint(e,t,e[t]));return e}function insertEscapedCodePoint(e,n,t){const o=t.toString(16),r=[];for(const e of o)r.push(e.codePointAt(0));const i=e[n+1];return n===e.length-1||i&&isHexDigitCodePoint(i)?(e.splice(n,1,92,...r,32),1+r.length):(e.splice(n,1,92,...r),r.length)}const a=Object.values(i);function isToken(e){return!!Array.isArray(e)&&(!(e.length<4)&&(!!a.includes(e[0])&&("string"==typeof e[1]&&("number"==typeof e[2]&&"number"==typeof e[3]))))}function isTokenNumeric(e){if(!e)return!1;switch(e[0]){case i.Dimension:case i.Number:case i.Percentage:return!0;default:return!1}}function isTokenWhiteSpaceOrComment(e){if(!e)return!1;switch(e[0]){case i.Whitespace:case i.Comment:return!0;default:return!1}}function isTokenAtKeyword(e){return!!e&&e[0]===i.AtKeyword}function isTokenBadString(e){return!!e&&e[0]===i.BadString}function isTokenBadURL(e){return!!e&&e[0]===i.BadURL}function isTokenCDC(e){return!!e&&e[0]===i.CDC}function isTokenCDO(e){return!!e&&e[0]===i.CDO}function isTokenColon(e){return!!e&&e[0]===i.Colon}function isTokenComma(e){return!!e&&e[0]===i.Comma}function isTokenComment(e){return!!e&&e[0]===i.Comment}function isTokenDelim(e){return!!e&&e[0]===i.Delim}function isTokenDimension(e){return!!e&&e[0]===i.Dimension}function isTokenEOF(e){return!!e&&e[0]===i.EOF}function isTokenFunction(e){return!!e&&e[0]===i.Function}function isTokenHash(e){return!!e&&e[0]===i.Hash}function isTokenIdent(e){return!!e&&e[0]===i.Ident}function isTokenNumber(e){return!!e&&e[0]===i.Number}function isTokenPercentage(e){return!!e&&e[0]===i.Percentage}function isTokenSemicolon(e){return!!e&&e[0]===i.Semicolon}function isTokenString(e){return!!e&&e[0]===i.String}function isTokenURL(e){return!!e&&e[0]===i.URL}function isTokenWhitespace(e){return!!e&&e[0]===i.Whitespace}function isTokenOpenParen(e){return!!e&&e[0]===i.OpenParen}function isTokenCloseParen(e){return!!e&&e[0]===i.CloseParen}function isTokenOpenSquare(e){return!!e&&e[0]===i.OpenSquare}function isTokenCloseSquare(e){return!!e&&e[0]===i.CloseSquare}function isTokenOpenCurly(e){return!!e&&e[0]===i.OpenCurly}function isTokenCloseCurly(e){return!!e&&e[0]===i.CloseCurly}function isTokenUnicodeRange(e){return!!e&&e[0]===i.UnicodeRange}export{c as HashType,s as NumberType,ParseError,e as ParseErrorMessage,ParseErrorWithToken,i as TokenType,cloneTokens,isToken,isTokenAtKeyword,isTokenBadString,isTokenBadURL,isTokenCDC,isTokenCDO,isTokenCloseCurly,isTokenCloseParen,isTokenCloseSquare,isTokenColon,isTokenComma,isTokenComment,isTokenDelim,isTokenDimension,isTokenEOF,isTokenFunction,isTokenHash,isTokenIdent,isTokenNumber,isTokenNumeric,isTokenOpenCurly,isTokenOpenParen,isTokenOpenSquare,isTokenPercentage,isTokenSemicolon,isTokenString,isTokenURL,isTokenUnicodeRange,isTokenWhiteSpaceOrComment,isTokenWhitespace,mirrorVariant,mirrorVariantType,mutateIdent,mutateUnit,stringify,tokenize,tokenizer};
