import { formatDistance } from "./hy/_lib/formatDistance.js";
import { formatLong } from "./hy/_lib/formatLong.js";
import { formatRelative } from "./hy/_lib/formatRelative.js";
import { localize } from "./hy/_lib/localize.js";
import { match } from "./hy/_lib/match.js";

/**
 * @category Locales
 * @summary Armenian locale
 * @language Armenian
 * @iso-639-2 arm
 * @author Alex Igityan [@alexigityan](https://github.com/alexigityan)
 */
export const hy = {
  code: "hy",
  formatDistance: formatDistance,
  formatLong: formatLong,
  formatRelative: formatRelative,
  localize: localize,
  match: match,
  options: {
    weekStartsOn: 1 /* Monday */,
    firstWeekContainsDate: 1,
  },
};

// Fallback for modularized imports:
export default hy;
