"use strict";

function HtmlWebpackSimpleIncludePlugin(options) {
  options = Array.isArray(options) ? options : [options];
  options.forEach(function (option) {
    if (typeof option.tag == 'undefined' || typeof option.content == 'undefined') {
      throw new Error('Both `tag` and `content` options must be defined!');
    }
  });

  this.replace = function (inData, callback) {
    options.forEach(function (option) {
      inData.html = inData.html.replace(new RegExp(option.tag, "g"), option.content);
    });
    callback(null, inData);
  };
}

HtmlWebpackSimpleIncludePlugin.prototype.apply = function (compiler) {
  var _this = this;

  if (compiler.hooks) {
    compiler.hooks.compilation.tap('HtmlWebpackSimpleIncludePlugin', function (compilation) {
      if (compilation.hooks.htmlWebpackPluginAfterHtmlProcessing) {
        compilation.hooks.htmlWebpackPluginAfterHtmlProcessing.tapAsync('HtmlWebpackSimpleIncludePlugin', _this.replace);
      } else {
        var HtmlWebpackPlugin = require('html-webpack-plugin');

        if (!HtmlWebpackPlugin) {
          throw new Error('Make sure `html-webpack-plugin` is placed before `html-webpack-simple-include-plugin` in your Webpack config if you were working with Webpack 4.x.x!');
        }

        HtmlWebpackPlugin.getHooks(compilation).afterTemplateExecution.tapAsync('HtmlWebpackSimpleIncludePlugin', _this.replace);
      }
    });
  } else {
    compiler.plugin('compilation', function (compilation) {
      compilation.plugin('html-webpack-simple-include-plugin-afterTemplateExecution', _this.replace);
    });
  }
};

module.exports = HtmlWebpackSimpleIncludePlugin;